<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <!-- Least Squares Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis metody nejmenších čtverců Souhrn</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <xsl:for-each select="AdjustmentNet">
                                <center>
                                    <!-- Report Title -->
                                    <h2 lang="en">Výpis metody nejmenších čtverců Souhrn</h2>
                                    <p lang="en">
                                        Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                        Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                    </p>
                                </center>
                                <p lang="en" style="text-align:center;font-size:80%">
                                    <strong>Aktivní geografický systém:&#xa0;</strong>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                                    <xsl:if test="//@linearUnits = 'I'">, stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'F'">, Survey stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'M'">, metry</xsl:if>
                                </p>
                                <hr/>
                                <xsl:for-each select="LeastSquaresV�choz�s">
                                    <center>
                                        <h4>Metoda nejmenších čtverců Výchozí</h4>
                                    </center>
                                    <hr size="1px"/>
                                    <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                                        <tbody>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Kombinovaný koeficient měřítka:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="//@combinedScaleFactorOption"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Kombinovaný koeficient měřítka:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@combinedScaleFactorValue))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Zobrazovat chyby v Okně zpráv:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="//@displayErrorInMessageCenter"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro Koeficient vzdálenosti:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addDistConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro Vzdálenost PPM:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addDistPpm))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro směrový úhel:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addHorzAngle))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro azimut:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addAzimuth))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro koeficient Trig výšku:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addTrigLevConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro Trig výšku PPM:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addTrigLevPpm))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Doplněk pro koeficient rozdílu výšky:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@addDiffLevConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí vzdálenost pro koeficient odhadu chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errDistConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí vzdálenost PPM:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errDistPpm))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí Směrový úhel Odhad chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errHorzAngle))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí Azimut Odhad chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errAzimuth))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí koeficient Trig výška Odhad chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errTrigLevConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výchozí koeficient Rozdíl výšek Odhad chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@errDiffLevConst))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Délková tolerance:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@tolDistance))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Úhlová tolerance:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@tolAngle))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výšková tolerance:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@tolElevation))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Chyba nastavení:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@setupError))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">XYZ počet des. míst:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@xyzDecPlaces"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Použít opakování chyb PLUS doplněk pro odhad chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@error"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výpočet souřadnic Standardní chyba a chyba elipsy:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@computeCoord"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výpočet zakřivní země a atmosférická refrakce:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@earthCurvature"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Úhly vyvážení:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@angleBalance"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>&#xa0;</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                                <xsl:for-each select="ReportHeader">
                                    <hr size="1px"/>
                                    <center>
                                        <h4>Souhrn</h4>
                                    </center>
                                    <hr size="1px"/>
                                    <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                        <tbody>
                                            <tr>
                                                <th align="left">
                                                    <xsl:choose>
                                                        <xsl:when test="//@adjustmentConverges='true'">Metoda nejmenších čtverců konvergovala.</xsl:when>
                                                        <xsl:otherwise>Metoda nejmenších čtverců nekonvergovala.</xsl:otherwise>
                                                    </xsl:choose>
                                                </th>
                                            </tr>
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Počet testů:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="//@numberOfBenchMarks"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Počet stanic:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="//@numberOfStations"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Počet měření:&#xa0;</th>
                                                <td align="left" nowrap="nowrap">
                                                    <xsl:value-of select="//@numberOfMeasurements"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Počet potřebných výrazů pro normálové rovnice:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@numberOfRequiredTermsForNormalEquations"/>
                                                </td>
                                            </tr>
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Směrově stupně volnosti:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@horizDegreesOfFreedom"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Spodní Směrově chi-čtverec 5% úroveň:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@horizChiLower))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Směrově standardní chyba jednotek váhy:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@horizStandardErrorOfUnitWeight))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Horní Směrově chi-čtverec 5% úroveň:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@horizChiUpper))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Směrově 95% spolehlivost F statistický násobek chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@horizConfidenceStatisticMultiplier))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                    <xsl:choose>
                                                        <xsl:when test="//@horizChiPassed='upper'">
                                                		<th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
	                                                            Upozornění! Směrově test Chi-čtverce překročil horní hranici
								 </th>
                                                        </xsl:when>
                                                        <xsl:when test="//@horizChiPassed='lower'">
                                                		<th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
	                                                            Upozornění! Směrově test Chi-čtverce překročil spodní hranici
								 </th>

                                                        </xsl:when>
                                                        <xsl:when test="//@horizChiPassed='passed'">
								<th align="left" colspan="2" nowrap="nowrap">
	                                                            Směrově test Chi-čtverce vyhověl
								</th>
                                                        </xsl:when>
                                                    </xsl:choose>

                                            </tr>
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výškově stupně volnosti:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="//@levelDegreesOfFreedom"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Spodní Výškově Chi-čtverec 5% úroveň:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@levelChiLower))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výškově standardní chyba váhy jednotek:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@levelStandardErrorOfUnitWeight))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Horní Výškově Chi-čtverec 5% úroveň:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@levelChiUpper))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" nowrap="nowrap">Výškově 95% spolehlivost F statistický násobek chyby:&#xa0;</th>
                                                <td align="left">
                                                    <xsl:value-of select="cif:distanceFormat(number(//@levelConfidenceStatisticMultiplier))"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                    <xsl:choose>
                                                        <xsl:when test="//@levelChiPassed='upper'">
                                                		<th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
	                                                           Upozornění! Výškově Chi-čtverec test překročil horní hranici
								 </th>
                                                        </xsl:when>
                                                        <xsl:when test="//@levelChiPassed='lower'">
                                                		<th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
	                                                            Upozornění! Výškově Chi-čtverec test překročil spodní hranici
								 </th>

                                                        </xsl:when>
                                                        <xsl:when test="//@levelChiPassed='passed'">
								<th align="left" colspan="2" nowrap="nowrap">
	                                                            Výškově test Chi-čtverce vyhověl
								</th>
                                                        </xsl:when>
                                                    </xsl:choose>
                                            </tr>
                                            <tr>
                                                <td>&#xa0;</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
       </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
              Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje síť měření s provedeným vyrovnáním.
	</p>

<p class="normal1">  V Průzkumníku projektu se ujistěte, že vpravo od Vyrovnání svítí zelená značka (ukazuje kompletní provedení). Pravým kliknutím na Vyrovnání vyberte Výsledky vyrovnání pro odpovídající výpis.  </p>
            <p class="normal1">Po otevření Průzkumníka výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
    </xsl:stylesheet>
